import java.time.*;

/**
 * Ten program sprawdza dziaanie klasy Employee.
 * 
 * @version 1.12 2015-05-08
 * @author Cay Horstmann
 */
public class EmployeeTest {
	public static void main(String[] args) {
		// Wstawienie trzech obiektw pracownikw do tablicy staff.
		Employee[] staff = new Employee[3];

		staff[0] = new Employee("Robert Siwiak ", 75000, 1987, 12, 15);
		staff[1] = new Employee("Jacek Cydejko ", 50000, 1989, 10, 1);
		staff[2] = new Employee("Mariusz Romaczuk ", 40000, 1990, 3, 15);

		// Zwikszenie pensji wszystkich pracownikw o 5%.
		for (Employee e : staff)
			e.raiseSalary(5);

		// Drukowanie informacji o wszystkich obiektach klasy Employee.
		for (Employee e : staff)
			System.out.println("name=" + e.getName() + ",salary=" + e.getSalary() + ",hireDay=" + e.getHireDay());
	}
}

class Employee {
	private String name;
	private double salary;
	private LocalDate hireDay;

	public Employee(String n, double s, int year, int month, int day) {
		name = n;
		salary = s;
		hireDay = LocalDate.of(year, month, day);
	}

	public String getName() {
		return name;
	}

	public double getSalary() {
		return salary;
	}

	public LocalDate getHireDay() {
		return hireDay;
	}

	public void raiseSalary(double byPercent) {
		double raise = salary * byPercent / 100;
		salary += raise;
	}
}
