// Przykład zastosowania klasy CountDownLatch

import java.util.concurrent.CountDownLatch;

class CDLDemo {
   public static void main(String[] args) {
      CountDownLatch cdl = new CountDownLatch(5);

       System.out.println("Start");

      new Thread(new MyThread(cdl)).start();

      try {
         cdl.await();
      } catch (InterruptedException exc) {
         System.out.println(exc);
      }

      System.out.println("Gotowe");
   }
}

class MyThread implements Runnable {
   CountDownLatch latch;

   MyThread(CountDownLatch c) {
      latch = c;
   }

   public void run() {
      for(int i = 0; i<5; i++) {
         System.out.println(i);
         latch.countDown(); // Zmniejszenie wartości licznika
      }
   }
}
