// Prosty przykład użycia rekordów

// Deklaracja typu Employee. Jej użycie powoduje automatyczne
// utworzenie klasy rekordu zawierającej prywatne finalne pola
// o nazwach name i idNum, jak również metody pobierające o nazwach
// name() i idNum() zapewniające możliwość odczytu wartości 
// tych pól
record Employee(String name, int idNum) {}

class RecordDemo { 
  public static void main(String[] args) { 
    // Tworzymy tablicę rekordów Employee
    Employee[] empList = new Employee[4];

    // Tworzymy listę pracowników zapisanych jako rekordy Employee.
    // Zwróć uwagę na sposób tworzenia poszczególnych rekordów.
    // Podczas tworzenia rekordu podawane argumenty są automatycznie 
    // zapisywane w polach name oraz idNum
    empList[0] = new Employee("Nowak, Jan", 1047);
    empList[1] = new Employee("Wilk, Ewa", 1048);
    empList[2] = new Employee("Puchacz, Roman", 1049);
    empList[3] = new Employee("Kowalski, Daniel", 1050);

    // Zastosowanie rekordów do wyświetlenia danych pracowników
    for(Employee e: empList) 
      System.out.println("Pracownik " + e.name() + " ma identyfikator " + e.idNum());
  }
}
