record Employee(String name, int idNum) {

  // Zastosowanie skróconego konstruktora kanoniczneg do usuwania odstępów
  // z początku i końca komponentu name. Konstruktor wykonuje także 
  // prostą walidację upewniając czy łańcuch przekazany w parametrze 
  // name jest zapisany w formacie: nazwisko, imię
  public Employee {
    // Usuwamy znaki odstępu z początku i końca łańcucha
    name = name.trim();

    // Dalszy kod konstruktora wykonuje proste testy by upewnić się, 
    // że przekazany łańcuch został zapisany w formacie: nazwisko, imię
    //
    // W pierwszej kolejności sprawdzamy czy łańcuch zawiera tylko jeden przecinek
    int i = name.indexOf(','); // szukamy przecinka po nazwisku
    int j = name.lastIndexOf(',');
    if(i != j) throw
      new IllegalArgumentException("Znaleziono więcej niż jeden przecinek");

    // Następnie sprawdzamy, czy zarówno przed, jak i za przecinkiem zapisano
    // przynajmniej jeden znak inny od spacji 
    if(i < 1 | name.length() == i+1) throw 
      new IllegalArgumentException("Wymagany format to: nazwisko, imię");
  }
}

public class EmployeeValidation {

  public static void main(String[] args) { 
    Employee[] empList = new Employee[4];

    empList[0] = new Employee("Nowak, Jan", 1047);
    
    // Każda z kolejnych instrukcji zgłosi wyjątek, dlatego zostały one
    // zapisane w komentarzu
    
    // Brak przecinka pomiędzy nazwiskiem i imieniem
    //empList[1] = new Employee("Wilk  Ewa", 1048);
    
    // Dodatkowy przecinek
    //empList[1] = new Employee("Wilk, , Ewa", 1048);
    
    // Brak nazwiska
    //empList[1] = new Employee(", Ewa", 1048);

  }  
  
}
