// Prosty aplet Swing
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/*
<applet code="MySwingApplet" width=220 height=90>
</applet>
*/
public class MySwingApplet extends JApplet {
  JButton jbtnAlpha;
  JButton jbtnBeta;
  JLabel jlab;

  // inicjalizacja apletu
  public void init() {
    try {
      SwingUtilities.invokeAndWait(new Runnable () {
        public void run() {
          makeGUI(); // inicjalizacja graficznego interfejsu użytkownika
        }
      });
    } catch(Exception exc) {
      System.out.println("Nie można utworzyć apletu! Przyczyna: "+ exc);
    }
  }

  // W tym aplecie nie trzeba przesłaniać metod start(), stop() oraz destroy().
  // Ta metoda inicjuje graficzny interfejs użytkownika apletu.
  private void makeGUI() {
    // używa menedżera układu FlowLayout
    setLayout(new FlowLayout());
    
    // tworzy dwa przyciski
    jbtnAlpha = new JButton("Alfa");
    jbtnBeta = new JButton("Beta");
    
    // określa obiekt nasłuchujący zdarzeń przycisku Alfa
    jbtnAlpha.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent le) {
        jlab.setText("Naciśnięto przycisk Alpha.");
      }
    });
    
    // określa obiekt nasłuchujący zdarzeń przycisku Beta
    jbtnBeta.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent le) {
        jlab.setText("Naciśnięto przycisk Beta.");
      }
    });
    
    // dodaje przyciski do panelu zawartości
    add(jbtnAlpha);
    add(jbtnBeta);
    
    // tworzy etykietę 
    jlab = new JLabel("Kliknij któryś z przycisków.");
    
    // dodaje etykietę do panelu zawartości
    add(jlab);
  }
}
