// Przykład użycia listy właściwości.
import java.util.*;

class PropDemo {
  public static void main(String args[]) {
    Properties capitals = new Properties();

    capitals.put("śląskiego", "Katowice");
    capitals.put("małopolskiego", "Kraków");
    capitals.put("mazowieckiego", "Warszawa");
    capitals.put("opolskiego", "Opole");
    capitals.put("wielkopolskiego", "Poznań");

    // Pobranie widoku kluczy.
    Set<?> states = capitals.keySet();

    // Wyświetlenie województw i miast.
    for(Object name : states)
      System.out.println("Miastem wojewódzkim województwa " +
                         name + " jest " +
                         capitals.getProperty((String)name)
                         + ".");

    System.out.println();

    // Poszukiwanie województwa spoza listy - skorzystanie z wartości domyślnej.
    String str = capitals.getProperty("świętokrzyskie", "nie znaleziono");
    System.out.println("Miastem wojewódzkim województwa świętokrzyskiego jest "
                       + str + ".");
  }
}
