// Prezentacja kontrolki TreeView. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.beans.value.*; 
import javafx.geometry.*; 
 
public class TreeViewDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja kontrolki TreeView"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10.  
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 340, 460); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę, w której będzie wyświetlana nazwa wybranego
    // węzła drzewa. 
    response = new Label("Jeszcze nic nie wybrano."); 
 
    // Tworzy węzły drzewa, zaczynając od korzenia. 
    TreeItem<String> tiRoot = new TreeItem<String>("Pożywienie"); 
     
    // Tworzenie poddrzew - na początku Owoce 
    TreeItem<String> tiFruit = new TreeItem<String>("Owoce"); 
  
    // Tworzy poddrzewo jabłek. 
    TreeItem<String> tiApples = new TreeItem<String>("Jabłka"); 
    // Tworzy węzły dzieci. 
    tiApples.getChildren().add(new TreeItem<String>("Koksa")); 
    tiApples.getChildren().add(new TreeItem<String>("Jonatan")); 
    tiApples.getChildren().add(new TreeItem<String>("Antonówka")); 

    // Pozostałe węzły owoców.
    tiFruit.getChildren().add(tiApples); 
    tiFruit.getChildren().add(new TreeItem<String>("Gruszki"));
    tiFruit.getChildren().add(new TreeItem<String>("Pomarańcze")); 

    // Dodaje węzeł owoców do drzewa. 
    tiRoot.getChildren().add(tiFruit); 
 
    // Tworzy poddrzewo warzyw, postępując w ten sam sposób
    // jak powyżej. 
    TreeItem<String> tiVegetables = new TreeItem<String>("Warzywa"); 
    tiVegetables.getChildren().add(new TreeItem<String>("Kukurydza")); 
    tiVegetables.getChildren().add(new TreeItem<String>("Groszek")); 
    tiVegetables.getChildren().add(new TreeItem<String>("Brokuły")); 
    tiVegetables.getChildren().add(new TreeItem<String>("Fasola")); 
    tiRoot.getChildren().add(tiVegetables); 
 
    // Tworzy poddrzewo orzechów. 
    TreeItem<String> tiNuts = new TreeItem<String>("Orzechy"); 
    tiNuts.getChildren().add(new TreeItem<String>("Laskowe")); 
    tiNuts.getChildren().add(new TreeItem<String>("Ziemne")); 
    tiNuts.getChildren().add(new TreeItem<String>("Włoskie")); 
    tiRoot.getChildren().add(tiNuts); 
 
    // Tworzy kontrolkę TreeView, używając w niej przygotowanego 
    // wcześniej drzewa owoców - tiRoot.
    TreeView<String> tvFood = new TreeView<String>(tiRoot); 
 
    // Pobiera model wyboru kontrolki TreeView. 
    MultipleSelectionModel<TreeItem<String>> tvSelModel = 
                                     tvFood.getSelectionModel(); 
 
    // Określa obiekt nasłuchujący, obsługujący wybieranie 
    // poszczególnych elementów drzewa.
    tvSelModel.selectedItemProperty().addListener( 
                           new ChangeListener<TreeItem<String>>() { 
      public void changed( 
                  ObservableValue<? extends TreeItem<String>> changed, 
                      TreeItem<String> oldVal, TreeItem<String> newVal) { 
 
        // Wyświetla nazwę wybranego węzła oraz pełną ścieżkę do niego
        // aż do korzenia drzewa.
        if(newVal != null) { 
 
          // Tworzy pełną ścieżkę do korzenia.
          String path = newVal.getValue(); 
          TreeItem<String> tmp = newVal.getParent(); 
          while(tmp != null) { 
            path = tmp.getValue() + " -> " + path; 
            tmp = tmp.getParent(); 
          } 
 
          // Wyświetla wybrany element i ścieżkę do korzenia.
          response.setText("Wybrano element: " + newVal.getValue() + 
                           "\nPełna ścieżka: " + path); 
        } 
      } 
     }); 
 
    // Dodaje kontrolki do grafu sceny. 
    rootNode.getChildren().addAll(tvFood, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
