// Prezentacja kontrolki ScrollPane.  
// Ten program przedstawia przewijanie zawartości
// wielowierszowej etykiety, jednak trzeba pamiętać,
// że przewijać można zawartość dowolnego węzła.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*; 
import javafx.geometry.*; 
  
public class ScrollPaneDemo extends Application {  
  
  ScrollPane scrlPane; 
 
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.  
    launch(args);    
  }  
  
  // Przesłonięta metoda start().  
  public void start(Stage myStage) {  
  
    // Określa nazwę obszaru roboczego.  
    myStage.setTitle("Prezentacja kontrolki ScrollPane");  
  
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. 
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny.  
    Scene myScene = new Scene(rootNode, 300, 200);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.  
    myStage.setScene(myScene);  
 
    // Tworzy etykietę, której zawartość będzie przewijana. 
    Label scrlLabel = new Label( 
                          "Kontrolka ScrollPane znacznie ułatwia proces\n" + 
                          "dodawania pasków przewijania do okien, których\n" + 
                          "zawartość przekracza ich wymiary.\n" + 
                          "Oprócz tego pozwala zmieścić kontrolkę w mniejszym \n" + 
                          "obszarze niż ten, w którym trzeba by ją normalnie \n" + 
                          "umieścić. \n\n" +
                          "Dzięki temu stosowanie kontrolki ScrollPane jest \n" + 
                          "zazwyczaj znacznie lepszym rozwiązaniem niż korzystanie \n" +
                          "z niezależnych pasków przewijania.");  
 
    // Tworzy panel ScrollPane, którego zawartością będzie 
    // etykieta scrlLabel.
    scrlPane = new ScrollPane(scrlLabel); 
 
    // Określa wymiary obszaru prezentacyjnego kontrolki ScrollPane.
    scrlPane.setPrefViewportWidth(130); 
    scrlPane.setPrefViewportHeight(80); 
 
    // Włącza możliwość przewijania zawartości przy użyciu myszy. 
    scrlPane.setPannable(true); 
 
 
    // Tworzy przycisk do przywracania stanu początkowego. 
    Button btnReset = new Button("Przywróć stan początkowy pasków przewijania"); 
 
    // Obsługa zdarzeń przycisku. 
    btnReset.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        // Suwaki pasków zostaną przesunięte do pozycji 0. 
        scrlPane.setVvalue(0); 
        scrlPane.setHvalue(0); 
      } 
    }); 
 
    // Dodaje kontrolki do grafu sceny.  
    rootNode.getChildren().addAll(scrlPane, btnReset);  
  
    // Wyświetla obszar roboczy i scenę.  
    myStage.show();  
  }  
}
