// Prezentacja listy kombinowanej. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.geometry.*; 
import javafx.collections.*; 
import javafx.event.*; 
 
 
public class ComboBoxDemo extends Application { 
 
  ComboBox<String> cbTransport; 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja listy kombinowanej"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 380, 190); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label(); 
 
    // Tworzy listę ObservableList elementów, które będą prezentowane
    // na liście kombinowanej. 
    ObservableList<String> transportTypes = 
      FXCollections.observableArrayList( "Pociąg", "Samochód", "Samolot" );  
 
    // Tworzy listę kombinowaną - kontrolkę ComboBox. 
    cbTransport = new ComboBox<String>(transportTypes); 
 
    // Ustawia wartość domyślną. 
    cbTransport.setValue("Pociąg"); 
 
    // Ustawia zawartość etykiety response, tak by odpowiadała ona domyślnej
    // wartości listy cbTransport.
    response.setText("Wybranym środkiem transportu jest: " + cbTransport.getValue()); 
 
    // Obsługa zdarzeń ActionEvent generowanych przez kontrolkę ComboBox. 
    cbTransport.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Wybranym środkiem transportu jest: " + cbTransport.getValue()); 
      } 
    }); 
 
    // Dodaje etykietę i listę kombinowaną do grafu sceny. 
    rootNode.getChildren().addAll(cbTransport, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
