// Ten przykład demonstruje, w jaki sposób można programowo
// w wybranym momencie odczytać, który z przycisków opcji 
// w grupie jest zaznaczony; dzięki czemu nie trzeba 
// obsługiwać zdarzeń generowanych przez przyciski opcji 
// lub ich grupę.
// 
// W tym programie nie są obsługiwane żadne zdarzenia 
// generowane przez przyciski opcji lub ich grupę. 
// Zamiast tego aktualnie zaznaczone pole wyboru zostaje
// określone podczas obsługi kliknięcia przycisku 
// Potwierdź wybór środka transportu.
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class RadioButtonDemo2 extends Application { 
 
  Label response; 
  ToggleGroup tg; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja przycisków opcji"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 250, 140); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy dwie etykiety. 
    Label choose = new Label("           Wybierz środek transportu          ");
    response = new Label("Nie potwierdzono środka transportu."); 
 
    // Tworzy przycisk służący do potwierdzenia wybranego środka transportu.
    Button btnConfirm = new Button("Potwierdź wybór środka transportu"); 
 
    // Tworzy przyciski opcji.
    RadioButton rbTrain = new RadioButton("Pociąg"); 
    RadioButton rbCar = new RadioButton("Samochód"); 
    RadioButton rbPlane = new RadioButton("Samolot"); 
 
    // Tworzy grupę przycisków opcji. 
    tg = new ToggleGroup(); 
 
    // Dodaje poszczególne przyciski do grupy. 
    rbTrain.setToggleGroup(tg); 
    rbCar.setToggleGroup(tg); 
    rbPlane.setToggleGroup(tg); 
 
    // Określa początkowo zaznaczony przycisk opcji.
    rbTrain.setSelected(true); 
 
    // Obsługa zdarzeń przycisku potwierdzającego wybór.
    btnConfirm.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        // Pobiera aktualnie zaznaczony przycisk opcji.
        RadioButton rb = (RadioButton) tg.getSelectedToggle(); 
 
        // Wyświetla informacje o zaznaczonym przycisku. 
        response.setText("Postwierdzony środek transportu: " + rb.getText() + "."); 
      } 
    }); 
 
    // Tworzy separator, by poprawić wygląd układu. 
    Separator separator = new Separator(); 
    separator.setPrefWidth(180); 
 
    // Dodaje do grafu sceny etykiety i przyciski. 
    rootNode.getChildren().addAll(choose, rbTrain, rbCar, rbPlane, 
                                  separator, btnConfirm, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
