// Stosowanie obrazów w etykietach.  
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.geometry.*; 
import javafx.scene.image.*; 
  
public class LabelImageDemo extends Application {  
  
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.  
    launch(args);    
  }  
  
  // Przesłonięta metoda start().
  public void start(Stage myStage) {  
  
    // Określa nazwę obszaru roboczego.  
    myStage.setTitle("Stosowanie obrazów w etykietach");  
  
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia.  
    FlowPane rootNode = new FlowPane();  
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
  
    // Tworzy obiekt sceny.  
    Scene myScene = new Scene(rootNode, 300, 200);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.  
    myStage.setScene(myScene);  
 
    // Tworzy obiekt ImageView zawierający wskazany obraz.
    ImageView hourglassIV = new ImageView("hourglass.png"); 
  
    // Tworzy etykietę zawierającą tekst i obraz.
    Label hourglassLabel = new Label("Klepsydra", hourglassIV);  
    //hourglassLabel.setContentDisplay(ContentDisplay.TOP);
 
    // Dodaje etykietę do grafu sceny.
    rootNode.getChildren().add(hourglassLabel);  
 
    // Wyświetla obszar roboczy i scenę.  
    myStage.show();  
  }  
}
