// Umieszczanie obrazów na przyciskach. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
import javafx.scene.image.*; 
 
public class ButtonImageDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Umieszczanie obrazów na przyciskach"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku poziome i pionowe odstępy pomiędzy kontrolkami wynoszą 10.
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 250, 450); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Kliknij przycisk"); 
 
    // Tworzy dwa przyciski z tekstem i obrazkiem. 
    Button btnHourglass = new Button("Klepsydra", 
                                     new ImageView("hourglass.png")); 
    Button btnAnalogClock = new    Button("Zegar", 
                                     new ImageView("analog.png")); 
 
    // Rozmieszcza tekst poniżej obrazu. 
    //btnHourglass.setContentDisplay(ContentDisplay.TOP); 
    //btnAnalogClock.setContentDisplay(ContentDisplay.TOP); 
    btnHourglass.setContentDisplay(ContentDisplay.GRAPHIC_ONLY); 
    btnAnalogClock.setContentDisplay(ContentDisplay.GRAPHIC_ONLY); 
 
    // Obsługa zdarzeń przycisku klepsydry. 
    btnHourglass.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Kliknięto klepsydrę."); 
      } 
    }); 
 
    // Obsługa zdarzeń przycisku zegara. 
    btnAnalogClock.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Kliknięto zegar."); 
      } 
    }); 
 
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnHourglass, btnAnalogClock, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
