// Program wczytuje i wyświetla obraz. 
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.geometry.*; 
import javafx.scene.image.*; 
 
  
public class ImageDemo extends Application {  
  
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.
    launch(args);    
  }  
  
  // Przesłonięta metoda start().
  public void start(Stage myStage) {  
  
    // Określa tytuł obszaru roboczego.
    myStage.setTitle("Wyświetlanie obrazu");  
  
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. 
    FlowPane rootNode = new FlowPane();  
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
  
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 300, 200);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.
    myStage.setScene(myScene);  
 
    // Tworzy obraz. 
    Image hourglass = new Image("hourglass.png"); 
 
    // Tworzy obiekt ImageView korzystający z utworzonego 
    // wcześniej obiektu Image.
    ImageView hourglassIV = new ImageView(hourglass); 
  
    // Dodaje obraz do grafu sceny.
    rootNode.getChildren().add(hourglassIV);  
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show();  
  }  
}
