// Prezentacja transformacji Rotate i Scaling oraz
// efektów Glow oraz InnerShadow.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import javafx.scene.transform.*; 
import javafx.scene.effect.*; 
import javafx.scene.paint.*; 
  
public class EffectsAndTransformsDemo extends Application {  
  
  double angle = 0.0; 
  double glowVal = 0.0; 
  boolean shadow = false; 
  double scaleFactor = 1.0; 
 
  // Utworzenie początkowych efektów i transformacji.
  Glow glow = new Glow(0.0); 
  InnerShadow innerShadow = new InnerShadow(10.0, Color.RED); 
  Rotate rotate = new Rotate(); 
  Scale scale = new Scale(scaleFactor, scaleFactor); 
 
  // Tworzy przyciski.  
  Button btnRotate = new Button("Obrót");  
  Button btnGlow = new Button("Rozświetlenie");  
  Button btnShadow = new Button("Cień: wyłączony"); 
  Button btnScale = new Button("Skalowanie"); 
 
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.  
    launch(args);    
  }  
  
  // Przesłonięta metoda start().  
  public void start(Stage myStage) {  
  
    // Określa nazwę obszaru roboczego.  
    myStage.setTitle("Prezentacja efektów i transformacji");  
  
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10.  
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrównuje kontrolki na scenie do środka.  
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt sceny.  
    Scene myScene = new Scene(rootNode, 370, 120);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.  
    myStage.setScene(myScene);  
 
    // Stosuje początkowy efekt rozświetlenia. 
    btnGlow.setEffect(glow);    
 
    // Dodaje obrót do listy transformacji przycisku Obrót.
    btnRotate.getTransforms().add(rotate);  
 
    // Dodaje skalowanie do listy transformacji przycisku Skalowanie.
    btnScale.getTransforms().add(scale); 
 
    // Obsługa zdarzeń ActionEvent przycisku Obrót.
    btnRotate.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje obrócenie przycisku
        // o 30 stopni względem jego środka.
        angle += 30.0; 
 
        rotate.setAngle(angle);        
        rotate.setPivotX(btnRotate.getWidth()/2); 
        rotate.setPivotY(btnRotate.getHeight()/2); 
      }  
    });  
  
    // Obsługa zdarzeń ActionEvent przycisku Skalowanie.
    btnScale.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje zmianę jego współczynników
        // skalowania.
        scaleFactor += 0.1; 
        if(scaleFactor > 1.0) scaleFactor = 0.4; 
 
        scale.setX(scaleFactor); 
        scale.setY(scaleFactor);         
 
      }  
    });  
 
 
    // Obsługa zdarzeń ActionEvent przycisku Rozświetlenie.  
    btnGlow.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje zmianę wartości efektu.
        glowVal += 0.1; 
        if(glowVal > 1.0) glowVal = 0.0; 
 
        // Ustawia nową wartość efektu. 
        glow.setLevel(glowVal); 
      }  
    });  
 
    // Obsługa zdarzeń ActionEvent przycisku Cień.
    btnShadow.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Każde kliknięcie przycisku powoduje włączenie lub 
        // wyłączenie cienia.
        shadow = !shadow; 
        if(shadow) { 
          btnShadow.setEffect(innerShadow);  
          btnShadow.setText("Cień: włączony"); 
        } else { 
          btnShadow.setEffect(null); 
          btnShadow.setText("Cień: wyłączony"); 
        } 
      }  
    });  
 
    // Dodaje kontrolki do grafu sceny.
    rootNode.getChildren().addAll(btnRotate, btnScale, btnGlow, btnShadow);  
 
    // Wyświetla obszar roboczy i scenę.  
    myStage.show();  
  }  
}
