package rozdzial30;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.robot.Robot;
import javafx.stage.Stage;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class Listing30_09 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Robot robot = new Robot();
            Button button = new Button("Kliknij");
            button.setOnAction(event -> {
                WritableImage wi = robot.getScreenCapture(
                        null,
                        new Rectangle2D(10, 10, 500, 250));
                File file = new File(
                        "src/rozdzial30/rys30.4.png");
                BufferedImage bi = SwingFXUtils.fromFXImage(wi, null);
                try {
                    ImageIO.write(bi, "png", file);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Jestem twoim robotem i zrobiłem zrzut ekranu!");
            });
            HBox root = new HBox();
            root.setSpacing(20);
            root.getChildren().addAll(button);
            Scene scene = new Scene(root, 410, 200);
            scene.setCursor(Cursor.DEFAULT);
            stage.setScene(scene);
            stage.setTitle("Robot");
            stage.setOnCloseRequest(e -> Platform.exit());
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
