package rozdzial28;

import javafx.concurrent.Task;

import java.util.Arrays;

public class LottoTask extends Task<String> {
    @Override
    protected String call() throws Exception {
        return withoutReturn(6, 49, true);
    }

    /**
     * Zwraca tablice k liczb wybraych losowo z tablicy od 1 do n liczb bez
     * zwracania (powtórzeń)
     *
     * @param k      int - liczba wybieranych liczb
     * @param n      int - największa liczba
     * @param sorted boolean - określa czy wyjściowa tablica liczb będzie
     *               posortowana czy nie, <code>true</code> oznacza tablicę posortowaną, <code>false</code>
     *               oznacza tablicę nie sortowaną
     * @return int[] - tablica wybranych liczb
     */
    public static String withoutReturn(int k, int n, boolean sorted) {
        int[] wynik = new int[k];
        if (k > n) {
            System.out
                    .println("pierwsza liczba nie moze byc wieksza od drugiej");
        } else {
            int[] liczby = new int[n];
            for (int j = 0; j < liczby.length; j++) {
                liczby[j] = j + 1;
            }
            for (int i = 0; i < wynik.length; i++) {
                int l = (int) Math.floor(Math.random() * n);
                wynik[i] = liczby[l];
                liczby[l] = liczby[n - 1];
                n--;
            }
            if (sorted) {
                Arrays.sort(wynik);
            }
        }
        return Arrays.toString(wynik);
    }
}
