package rozdzial23;

import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Listing23_02 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            ObservableList<PieChart.Data> ol = FXCollections
                    .observableArrayList();
            ol.add(new PieChart.Data("angielski", 89.7));
            ol.add(new PieChart.Data("hiszpański", 67.2));
            ol.add(new PieChart.Data("francuski", 56.0));
            ol.add(new PieChart.Data("niemiecki", 36.8));
            ol.add(new PieChart.Data("rosyjski", 32.7));
            ol.add(new PieChart.Data("szwedzki", 28.3));
            ol.add(new PieChart.Data("norweski", 13.9));
            ol.add(new PieChart.Data("holenderski", 12.8));
            PieChart pchart = new PieChart(ol);
            pchart.setTitle("Nauka języków");
            pchart.setLegendSide(Side.LEFT);
            for (PieChart.Data pd : pchart.getData()) {
                Node n = pd.getNode();
                Tooltip.install(n, new Tooltip(
                        String.valueOf(pd.getPieValue())));
            }
            StackPane root = new StackPane();
            root.getChildren().add(pchart);
            Scene scene = new Scene(root, 400, 300);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
