package rozdzial22;

import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.util.Callback;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class TextPageFactory implements Callback<Integer, Node> {
    private final ArrayList<String> al;

    public TextPageFactory(String path) {
        this.al = fileToString(path);
    }

    @Override
    public Node call(Integer param) {
        TextArea ta = new TextArea();
        ta.setPrefColumnCount(60);
        ta.setPrefRowCount(25);
        ta.setWrapText(true);
        for (int i = param * 25; i < param * 25 + 25; i++) {
            ta.appendText("\n" + al.get(i));
        }
        return ta;
    }

    public static ArrayList<String> fileToString(String file) {
        ArrayList<String> al = new ArrayList<>();
        FileReader fr = null;
        BufferedReader br = null;
        String line;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                al.add(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return al;
    }
}
