package rozdzial22;

import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;

public class Listing22_19 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ObservableList<Naklady> olist = Naklady.wstawDane();
            TableView<Naklady> tv1 = new TableView<>();
            tv1.setItems(olist);
            tv1.setEditable(true);
            TableColumn<Naklady, Integer> rokCol = new TableColumn<>("Rok");
            rokCol.setCellValueFactory(
                    new PropertyValueFactory<>("rok"));
            rokCol.setEditable(true);
            rokCol.setCellFactory(
                    TextFieldTableCell.forTableColumn(
                            new IntegerStringConverter()));
            TableColumn<Naklady, Double> oswiataCol = new TableColumn<>(
                    "Oświata");
            oswiataCol.setCellValueFactory(
                    new PropertyValueFactory<>("oswiata"));
            oswiataCol.setEditable(true);
            oswiataCol.setCellFactory(
                    TextFieldTableCell.forTableColumn(
                            new DoubleStringConverter()));
            TableColumn<Naklady, Double> kulturaCol = new TableColumn<>(
                    "Kultura");
            kulturaCol.setCellValueFactory(
                    new PropertyValueFactory<>("kultura"));
            TableColumn<Naklady, Double> zdrowieCol = new TableColumn<>(
                    "Zdrowie");
            zdrowieCol.setCellValueFactory(
                    new PropertyValueFactory<>("zdrowie"));
            tv1.getColumns().addAll(rokCol, oswiataCol, kulturaCol, zdrowieCol);
            root.getChildren().add(tv1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
