package rozdzial20;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class Listing20_13 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            final String TEXT = "<!DOCTYPE html>" + "<html>" + "<head>"
                    + "<title>Rozeta czterolistna</title>" + "</head>"
                    + "<body> " + "	<section>"
                    + "	<h1>Rozeta czterolistna</h1>"
                    + "	<p>Rozeta czterolistna jest określona równaniem parametrycznym:</p>"
                    + "	<p>x=2&alpha;sin&phi;cos<sup>2</sup>&phi;</p>"
                    + "	<p>y=2&alpha;sin<sup>2</sup>&phi;cos&phi;</p>"
                    + "	<canvas id=\"canvas\" width=\"300\" height=\"300\""
                    + "		style=\"border: 1px solid #238E3E;\">Zawartość możesz zobaczyć w"
                    + "		przeglądarce obsługującej element &lt;canvas&gt;"
                    + "		z kontekstem &#034;2d&#034;</canvas>"
                    + "	<script type=\"text/javascript\">"
                    + "	var rozeta4listna = function(size, liczbaPunktow, strokeStyle) {"
                    + "		ctx.save();" + "		ctx.beginPath();"
                    + "		ctx.strokeStyle = strokeStyle;"
                    + "		ctx.translate(w / 2, h / 2);" + "		var x1 = 0;"
                    + "		var y1 = 0;" + "		var x2;" + "		var y2;"
                    + "		for ( var i = 0; i < liczbaPunktow; i++) {"
                    + "			var t = i * Math.PI / 360;"
                    + "			x2 = 2 * size * Math.sin(t) * Math.pow(Math.cos(t), 2);"
                    + "			y2 = 2 * size * Math.cos(t) * Math.pow(Math.sin(t), 2);"
                    + "			ctx.moveTo(Math.floor(x1), Math.floor(y1));"
                    + "			ctx.lineTo(Math.floor(x2), Math.floor(y2));"
                    + "			x1 = x2;" + "			y1 = y2;" + "		}"
                    + "		ctx.stroke();" + "		ctx.restore();" + "	};"
                    + "		var cv = document.getElementById(\"canvas\");"
                    + "		var ctx = cv.getContext(\"2d\");"
                    + "		var w = cv.width;" + "		var h = cv.height;"
                    + "		rozeta4listna(100, 1000, \"green\");"
                    + "	</script>" + "	</section>" + "</body>" + "</html>";
            StackPane root = new StackPane();
            HTMLEditor he = new HTMLEditor();
            he.setHtmlText(TEXT);
            root.getChildren().add(he);
            Scene scene = new Scene(root, 500, 300);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
