package rozdzial14;

import javafx.animation.Interpolator;

public class Listing14_12 extends Interpolator {
    private static final double S1 = 25.0 / 9.0;
    private static final double S3 = 10.0 / 9.0;
    private static final double S4 = 1.0 / 9.0;

    //	private int counter = 0;
    @Override
    protected double curve(double t) {
        // See the SMIL 3.1 specification for details on this calculation
        // acceleration = 0.2, deceleration = 0.0
        double temp = clamp((t < 0.2) ? S1 * t * t : S3 * t - S4);
        //System.out.println("t" + counter + "=" + roundToDecimal(temp, 2));
        //System.out.print("t" + counter + "=" + roundToDecimal(temp, 2) + ", ");
        System.out.print(roundToDecimal(temp, 2) + ", ");
        //counter++;
        return temp;
    }

    private static double clamp(double t) {
        return (t < 0.0) ? 0.0 : (t > 1.0) ? 1.0 : t;
    }

    public static double roundToDecimal(double num, int dec) {
        int multi = (int) Math.pow(10, dec);
        int temp = (int) Math.round(num * multi);
        return (double) temp / multi;
    }
}
