package rozdzial11;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing11_16 extends Application {
    private Timeline timeline;
public static void main(String[] args) {
        Application.launch(args);
    }
    @Override
    public void start(Stage stage) {
        Image image = new Image(
                "file:src/rozdzial11/kwiatek.jpg");
        ImageView iv = new ImageView();
        iv.setImage(image);
        iv.setFitWidth(256);
        iv.setFitHeight(192);
        iv.setSmooth(true);
        iv.setCache(true);
        iv.relocate(100, 75);
        ToggleButton tg = new ToggleButton("Włącz animację");
        BooleanProperty sel = tg.selectedProperty();
        sel.addListener((observable, oldValue, newValue)->{
            tg.setText(newValue ? "Wyłącz animację" : "Włącz animację");
            if(tg.selectedProperty().get()){
                timeline.play();
            }else{
                timeline.stop();
            }
        });
        Pane root = new Pane();
        root.getChildren().addAll(iv, tg);
        Scene scene = new Scene(root, 500, 400, Color.WHITE);
        stage.setTitle("Bouncing Image");
        stage.setScene(scene);
        stage.show();

        EventHandler<ActionEvent> ev = new EventHandler<>() {
            double dx = 5;
            double dy = 3;

            @Override
            public void handle(ActionEvent t) {
                iv.setLayoutX(iv.getLayoutX() + dx);
                iv.setLayoutY(iv.getLayoutY() + dy);
                Bounds bounds = root.getBoundsInLocal();
                if (iv.getLayoutX() <= (bounds.getMinX())
                        || iv.getLayoutX() >=
                        (bounds.getMaxX() - iv.getFitWidth())) {
                    dx = -dx;
                }
                if (iv.getLayoutY() >=
                        (bounds.getMaxY() - iv.getFitHeight())
                        || iv.getLayoutY() <= (bounds.getMinY() )) {
                    dy = -dy;
                }
            }
        };
        timeline = new Timeline(new KeyFrame(Duration.millis(40),ev));
        timeline.setCycleCount(Timeline.INDEFINITE);
        //timeline.play();
    }
    @Override
    public void stop() {
    //timeline.stop();
    }
}
