package rozdzial31;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.*;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.web.*;
import javafx.stage.FileChooser;
import javafx.stage.FileChooser.ExtensionFilter;
import javafx.stage.Stage;
import javafx.util.Callback;

import java.awt.*;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Optional;

public class Browser extends Region {

    private static final double BW = Toolkit.getDefaultToolkit()
            .getScreenSize().width * 0.99;
    private static final double BH = Toolkit.getDefaultToolkit()
            .getScreenSize().height * 0.89;
    private static final String homePage = "http://google.pl";
    private final FlowPane toolbar;
    private final WebView wv;
    private final WebEngine we;
    private final TextField tf;
    private final Button bback;
    private final Button bforward;
    private final FileChooser fc;
    private Node n;

    public Browser(Stage stage) {
        String url = "";
        getStyleClass().add("browser");
        wv = new WebView();
        we = wv.getEngine();
        //javaScript window.alert() handler
        we.setOnAlert(event -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Masz wiadomość!");
            alert.setHeaderText(event.getData());
            alert.initOwner(stage);
            alert.showAndWait();
        });
        //JavaScript window.confirm() handler
        we.setConfirmHandler(param -> {
            Alert conf = new Alert(Alert.AlertType.CONFIRMATION);
            conf.setTitle("Podejmij decyzję!");
            conf.setHeaderText(param);
            conf.setContentText("OK - jeśli chcesz\nCANCEL - jeśli nie chcesz");
            conf.initOwner(stage);
            return conf.showAndWait().get() == ButtonType.OK;
        });
        //JavaScript window.prompt() handler
        we.setPromptHandler(param -> {
            TextInputDialog dialog = new TextInputDialog(
                    param.getDefaultValue());
            dialog.setHeaderText(param.getMessage());
            dialog.initOwner(stage);
            Optional<String> op = dialog.showAndWait();
            return op.orElseGet(dialog::getDefaultValue);
        });
        //JavaScript window.open() - handler, to samo okno
        we.setCreatePopupHandler(param -> we);
        /*
        //JavaScript window.open() - handler, nowe okno
        we.setCreatePopupHandler(new Callback<PopupFeatures, WebEngine>() {
            @Override
            public WebEngine call(PopupFeatures param) {
                Stage stage1 = new Stage();
                WebView wv1 = new WebView();
                VBox root1 = new VBox(wv1);
                Scene scene1 = new Scene(root1, 560, 360);
                stage1.setScene(scene1);
                stage1.show();
                return wv1.getEngine();
            }
        });                 
        //JavaScript window.open() - handler, żadne okno
        we.setCreatePopupHandler(new Callback<PopupFeatures, WebEngine>() {
            @Override
            public WebEngine call(PopupFeatures param) {
                return null;
            }
        });
         */
        we.setOnResized(event -> {
            Rectangle2D r = event.getData();
            stage.setWidth(r.getWidth());
            stage.setHeight(r.getHeight());
        });
        //JavaScript window.open() i window.close() handler
        we.setOnVisibilityChanged(event -> {
            Boolean b = event.getData();
            if (!b) {
                stage.close();
            } else {
                stage.show();
            }
        });
        /*
        //window.status handler
        we.setOnStatusChanged(new EventHandler<WebEvent<String>>(){
            @Override
            public void handle(WebEvent<String> event) {
                throw new UnsupportedOperationException("Not supported yet."); 
                //TODO
            }
            
        });
        */
        we.getLoadWorker().stateProperty()
                .addListener(new ChangeListener<>() {
                    @Override
                    public void changed(
                            ObservableValue<? extends Worker.State> observable,
                            Worker.State oldValue, Worker.State newValue) {
                        if (newValue == Worker.State.SUCCEEDED) {
                            WebHistory myWH = we.getHistory();
                            tf.setText(we.getLocation());
                            bback.setDisable(we.getHistory().getCurrentIndex() <= 0);
                            if (myWH.getCurrentIndex() == myWH.getEntries()
                                    .size() - 1) {
                                bforward.setDisable(true);
                            } else {
                                bforward.setDefaultButton(false);
                            }
                        } else if (newValue == Worker.State.FAILED) {
                            tf.setText("Błąd " + we.getLoadWorker()
                                    .getException().getLocalizedMessage());
                        }
                    }
                });
        toolbar = new FlowPane();
        toolbar.setAlignment(Pos.TOP_LEFT);
        bback = new Button("<--");
        bback.setOnAction(event -> we.getHistory().go(-1));
        bback.setDisable(true);
        bforward = new Button("-->");
        bforward.setOnAction(event -> we.getHistory().go(1));
        bforward.setDisable(true);
        Button f5 = new Button("F5");
        f5.setOnAction(event -> we.reload());
        tf = new TextField(url);
        int cols = 60;
        tf.setPrefColumnCount(cols);
        tf.setOnAction(event -> we.load(tf.getText()));
        Button go = new Button("Go");
        go.setOnAction(event -> we.load(tf.getText()));
        Button home = new Button("Home");
        home.setOnAction(event -> we.load(homePage));
        fc = new FileChooser();
        fc.setTitle("Otwórz plik");
        fc.getExtensionFilters().addAll(new ExtensionFilter("Pliki HTML",
                " *.html", " *.htm", " *.jsp"));
        Button file = new Button("File");
        file.setOnAction(event -> {
            File file1 = fc.showOpenDialog(wv.getScene().getWindow());
            if (file1 != null) {
                try {
                    we.load(file1.toURI().toURL().toExternalForm());
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
        MenuButton mb = new MenuButton();
        mb.setText("Opcje");
        CheckMenuItem cmi = new CheckMenuItem("Menu kontekstowe dostępne");
        cmi.setSelected(true);
        wv.contextMenuEnabledProperty().bind(cmi.selectedProperty());
        CheckMenuItem cmijs = new CheckMenuItem("JavaScript włączony");
        cmijs.setSelected(true);
        wv.getEngine().javaScriptEnabledProperty()
                .bind(cmijs.selectedProperty());
        mb.getItems().addAll(cmi, cmijs);
        toolbar.getChildren().addAll(bback, bforward, f5, tf, go, home, file,
                mb);
        getChildren().addAll(toolbar, wv);
    }

    @Override
    protected void layoutChildren() {
        double w = getWidth();
        double h = getHeight();
        double th = toolbar.prefHeight(w);
        double wh = wv.prefHeight(w);
        layoutInArea(toolbar, 0, 0, w, th, 0, HPos.CENTER, VPos.CENTER);
        layoutInArea(wv, 0, th, w, h - th, 0, HPos.CENTER, VPos.CENTER);
        if (n != null) {
            layoutInArea(n, 0, th + wh, w, h - th - wh, 0, HPos.LEFT, VPos.TOP);
        }
    }

    @Override
    protected double computePrefWidth(double width) {
        return BW;
    }

    @Override
    protected double computePrefHeight(double height) {
        return BH;
    }

    public WebEngine getWe() {
        return we;
    }

    public void addChild(Node ch) {
        this.n = ch;
        getChildren().add(n);
    }
}
