package rozdzial35;

import javafx.application.Application;
import javafx.print.PrinterJob;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;
import rozdzial31.Browser;

import java.net.URL;

public class Listing35_04 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Browser root = new Browser(stage);
            WebEngine we = root.getWe();
            URL url = this.getClass().getClassLoader()
                    .getResource("resources/html/jinjang.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            Button druk = new Button("Drukuj");
            druk.setOnAction(event -> {
                PrinterJob pj = PrinterJob.createPrinterJob();
                if (pj == null) {
                    System.out.println("null");
                    return;
                }
                boolean proc = pj.showPrintDialog(stage);
                if (proc) {
                    we.print(pj);
                    pj.endJob();
                }
            });
            root.addChild(druk);
            Scene scene = new Scene(root, 700, 800);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
