package rozdzial27;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing27_01 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            //
            Label label = new Label("Przeciągnij tutaj tekst");
            //
            TextArea ta = new TextArea();
            ta.setPrefWidth(380);
            ta.setPrefHeight(380);
            //
            Button but = new Button("Usuń text");
            but.setOnAction(e -> ta.setText(null));
            root.getChildren().addAll(label, ta, but);
            Scene scene = new Scene(root, 400, 440);
            scene.setOnDragOver(e -> {
                Dragboard dbo = e.getDragboard();
                if (dbo.hasString()) {
                    e.acceptTransferModes(TransferMode.COPY);
                }
                e.consume();
            });
            scene.setOnDragDropped(e -> {
                boolean done = false;
                Dragboard dbo = e.getDragboard();
                if (dbo.hasString()) {
                    String txt = dbo.getString();
                    ta.setText(txt);
                    done = true;
                }
                e.setDropCompleted(done);
                e.consume();
            });
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
