package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Shadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class Listing13_03 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            //rectangle
            Rectangle rect = new Rectangle(280, 80, 150, 80);
            rect.setFill(Color.AQUAMARINE);
            //efekt
            Shadow ds = new Shadow();
            rect.setEffect(ds);
            //slider 4
            Slider rslider = new Slider(0, 127, 10);
            rslider.setLayoutX(60);
            rslider.setLayoutY(140);
            rslider.setMajorTickUnit(10);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            ds.radiusProperty().bind(rslider.valueProperty());
            Label rlabel = new Label("radius: ");
            rlabel.setLabelFor(rslider);
            rlabel.setLayoutX(20);
            rlabel.setLayoutY(140);
            //colorPicker
            ColorPicker cpicker1 = new ColorPicker(Color.BLACK);
            cpicker1.setLayoutX(60);
            cpicker1.setLayoutY(180);
            ds.colorProperty().bind(cpicker1.valueProperty());
            Label cp1label = new Label("color: ");
            cp1label.setLabelFor(cpicker1);
            cp1label.setLayoutX(20);
            cp1label.setLayoutY(180);
            //-
            ComboBox<BlurType> cbox = new ComboBox<>();
            cbox.getItems().addAll(BlurType.values());
            cbox.setLayoutX(70);
            cbox.setLayoutY(220);
            cbox.setValue(ds.getBlurType());
            ds.blurTypeProperty().bind(cbox.valueProperty());
            Label cb1label = new Label("BlurType: ");
            cb1label.setLabelFor(cbox);
            cb1label.setLayoutX(20);
            cb1label.setLayoutY(220);
            //
            root.getChildren().addAll(rlabel, rslider, cp1label, cpicker1,
                    cb1label, cbox, rect);
            Scene scene = new Scene(root, 560, 280);
            stage.setScene(scene);
            stage.setTitle("Shadow");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
