package rozdzial02;

import java.beans.*;
import java.io.Serial;
import java.io.Serializable;

public class Listing02_03 implements Serializable {

    @Serial
    private static final long serialVersionUID = -2355681914484737915L;
    private int liczbaKalorii;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final VetoableChangeSupport vcs = new VetoableChangeSupport(this);

    public Listing02_03() {
        this(0);
    }

    public Listing02_03(int liczbaKalorii) {
        this.liczbaKalorii = liczbaKalorii;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener list1) {
        pcs.addPropertyChangeListener(list1);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener list2) {
        pcs.removePropertyChangeListener(list2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener list3) {
        vcs.addVetoableChangeListener(list3);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener list4) {
        vcs.removeVetoableChangeListener(list4);
    }

    public int getLiczbaKalorii() {
        return liczbaKalorii;
    }

    public synchronized void setLiczbaKalorii(int newLiczbaKalori) throws PropertyVetoException {
        int oldValue = liczbaKalorii;
        vcs.fireVetoableChange("wartość poza dopuszczalnym przedziałem", Integer.valueOf(oldValue),
                Integer.valueOf(newLiczbaKalori));
        liczbaKalorii = newLiczbaKalori;
        pcs.firePropertyChange("zmiana liczby kalorii", Integer.valueOf(oldValue), Integer.valueOf(newLiczbaKalori));
    }

}
