package rozdzial32;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;

import javax.swing.*;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class Listing32_06 {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("JavaFX w Swingu");
            frame.setBounds(0, 0, 150, 100);
            final JFXPanel fxPanel = new JFXPanel();
            frame.add(fxPanel);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            Platform.runLater(() -> {
                VBox root = new VBox();
                URL url = fileToURL(
                        "src/resources/assets/taniec_smoczat.mp3");
                Media media = new Media(url.toString());
                media.setOnError(() -> {
                    System.out.println("Wystąpił błąd: " +
                            media.getError().getMessage());
                    System.out.println("Typ błędu: " +
                            media.getError().getType().toString());
                });
                MediaPlayer mp = new MediaPlayer(media);
                mp.setAutoPlay(false);
                MediaView mv = new MediaView(mp);
                Text text = new Text("\"Taniec smocząt\"");
                Button start = new Button("Start");
                start.setOnAction(e -> {
                    mp.play();
                    System.out.println("Czas trwania utworu: "
                            + media.getDuration().toSeconds() + "s.");
                    System.out.println("width: " + media.getWidth() +
                            ", height: "
                            + media.getHeight());
                });
                Button pause = new Button("Pauza");
                pause.setOnAction(e -> mp.pause());
                Button stop = new Button("Stop");
                stop.setOnAction(e -> mp.stop());
                HBox hbox = new HBox();
                hbox.getChildren().addAll(start, pause, stop);
                root.getChildren().addAll(text, mv, hbox);
                Scene scene = new Scene(root, 150, 100, Color.WHITE);
                fxPanel.setScene(scene);
            });
        });
    }
    public static URL fileToURL(String p) {
        File file = new File(p);
        URI uri = file.toURI();
        URL url = null;
        try {
            url = uri.toURL();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }
}
