package rozdzial30;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Objects;

public class Wycieczka extends Application {
    private  Hyperlink[] hpls;
    private ImageView selectedImage;

    @Override
    public void init(){
        String dir = "src/resources/Aria_i_Suita/";
        String[] linki = listFileNames(dir, "JPG");
        try {
            Image image1 = new Image(new
                    FileInputStream(dir + "IMG_0383.JPG"));
            selectedImage = new ImageView(image1);
            selectedImage.setFitWidth(1050);
            selectedImage.setFitHeight(588);
            hpls = new Hyperlink[linki.length];
            for (int i = 0; i < linki.length; i++) {
                hpls[i] = new Hyperlink(linki[i]);
                Image image = new Image(new FileInputStream(
                        dir + linki[i]));
                notifyPreloader(new Preloader.ProgressNotification(
                        (1.0/ linki.length)*(i+1)));
                hpls[i].setOnAction(e -> selectedImage.setImage(image));
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(Stage stage) {
        try{
        VBox box = new VBox();
        box.getChildren().addAll(hpls);
        HBox root = new HBox();
        root.getChildren().addAll(box, selectedImage);
        root.setSpacing(10);
        Scene scene = new Scene(root );
        stage.setScene(scene);
        stage.setOnCloseRequest(e -> Platform.exit());
        stage.setTitle("Wycieczka Arii i Suity z Terierogrodu - " +
                "https://terierogrod.pl");
        stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop(){
        System.clearProperty(
                "javafx.preloader");
    }

    public static String[] listFileNames(String dir,
                                         String... ext) {
        File file = new File(dir);
        File[] files = null;
        String[] names;
        if(file.isDirectory()){
            MultiFilter fef = new MultiFilter(file, ext);
            files = file.listFiles(fef);
        }
        else{
            System.out.println("Podaj nazwę katalogu z plikami");
        }
        names = new String[Objects.requireNonNull(files).length];
        for(int i = 0; i < files.length; i++){
            names[i] = files[i].getName();
        }
        return names;
    }
}
