package rozdzial30;

import java.io.*;
import java.util.*;

/**
 * Filtr plików dla podanych rozszerzeń
 */
public class MultiFilter implements FilenameFilter{
	private final String[] exts;
	private final String[] lowerExts;

	/**
	 * Tworzy obiekt filtra dla podanego katalogu i rozszerzeń
	 */
	public MultiFilter(File dir, String... exts){
		if(exts == null || exts.length == 0){
			throw new IllegalArgumentException(
				"Musisz podać przynajmniej jedno nie-puste rozszerzenie");
		}
		for(String i : exts){
			if(i == null || i.length() == 0){
				throw new IllegalArgumentException(
						"argument nie może  być ani 'null' ani 'pusty' ");
			}
		}
		this.exts = new String[exts.length];
		lowerExts = new String[exts.length];
		for(int i = 0; i < exts.length; i++){
			this.exts[i] = exts[i];
			lowerExts[i] = exts[i].toLowerCase(Locale.ENGLISH);
		}
	}

	@Override
	public boolean accept(File dir, String s) {
		for(int i = 0; i < lowerExts.length; i++){
			if(s.endsWith(exts[i])){
				return true;
			}
		}
		return false;
	}
}
