package rozdzial25;

import javafx.application.Application;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Listing25_11 extends Application {
    private GraphicsContext gc;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Group root = new Group();
            Canvas canvas = new Canvas(500, 500);
            gc = canvas.getGraphicsContext2D();
            double width = canvas.getWidth();
            double height = canvas.getHeight();
            Point2D start = new Point2D(3.0 * width / 8.0, 3.0 * height / 8.0);
            Point2D end = new Point2D(6.0 * width / 8, 3.0 * height / 8.0);
            drawDragon(start, end, 15, Color.BLUE);
            root.getChildren().add(canvas);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawDragon(Point2D start, Point2D end, int steps,
                            Paint strokeStyle) {
        gc.save();
        if (steps == 0) {
            gc.beginPath();
            gc.setStroke(strokeStyle);
            gc.moveTo(start.getX(), start.getY());
            gc.lineTo(end.getX(), end.getY());
            gc.stroke();
        } else {
            Point2D v1 = new Point2D((start.getX() + end.getX()) / 2,
                    (start.getY() + end.getY()) / 2);
            Point2D v2 = new Point2D(v1.getX() + end.getY() - v1.getY(),
                    v1.getY() + start.getX() - v1.getX());
            gc.setStroke(strokeStyle);
            drawDragon(end, v2, steps - 1, null);
            drawDragon(start, v2, steps - 1, null);
        }
        gc.stroke();
        gc.restore();
    }
}
