package rozdzial22;

import javafx.application.Application;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing22_04 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ObservableList<Naklady4> olist = Naklady4.wstawDane();
            TableView<Naklady4> tv1 = new TableView<>(olist);
            TableColumn<Naklady4, Integer> rokCol = new TableColumn<>("Rok");
            rokCol.setCellValueFactory(new YearCellValueFactory());
            TableColumn<Naklady4, Double> oswiataCol = new TableColumn<>(
                    "Oświata");
            oswiataCol.setCellValueFactory(param -> new ReadOnlyObjectWrapper<>(
                    param.getValue().getOswiata()));
            TableColumn<Naklady4, Double> kulturaCol = new TableColumn<>(
                    "Kultura");
            kulturaCol.setCellValueFactory(param -> new ReadOnlyObjectWrapper<>(
                    param.getValue().getKultura()));
            TableColumn<Naklady4, Double> zdrowieCol = new TableColumn<>(
                    "Zdrowie");
            zdrowieCol.setCellValueFactory(param -> new ReadOnlyObjectWrapper<>(
                    param.getValue().getZdrowie()));
            tv1.getColumns().setAll(rokCol, oswiataCol, kulturaCol, zdrowieCol);
            root.getChildren().add(tv1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
