package rozdzial20;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class Listing20_16 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            Slider rslider = new Slider(0.0, 1.0, 0.25);
            rslider.setMajorTickUnit(0.1);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            Label rlabel = new Label("red:");
            rlabel.setLabelFor(rslider);
            //
            Slider gslider = new Slider(0.0, 1.0, 0.5);
            gslider.setMajorTickUnit(0.1);
            gslider.setShowTickLabels(true);
            gslider.setShowTickMarks(true);
            Label glabel = new Label("green:");
            glabel.setLabelFor(rslider);
            //
            Slider bslider = new Slider(0.0, 1.0, 0.75);
            bslider.setMajorTickUnit(0.1);
            bslider.setShowTickLabels(true);
            bslider.setShowTickMarks(true);
            Label blabel = new Label("blue:");
            blabel.setLabelFor(bslider);
            //
            Slider aslider = new Slider(0.0, 1.0, 1.0);
            aslider.setMajorTickUnit(0.1);
            aslider.setShowTickLabels(true);
            aslider.setShowTickMarks(true);
            Label alabel = new Label("opacity:");
            alabel.setLabelFor(aslider);
            Rectangle rect = new Rectangle(460, 100);
            ChangeListener<Number> colorList = (observable, oldValue, newValue) -> rect.setFill(
                    Color.color(rslider.getValue(), gslider.getValue(),
                            bslider.getValue(), aslider.getValue()));
            rslider.valueProperty().addListener(colorList);
            gslider.valueProperty().addListener(colorList);
            bslider.valueProperty().addListener(colorList);
            aslider.valueProperty().addListener(colorList);
            rect.setFill(Color.color(rslider.getValue(), gslider.getValue(),
                    bslider.getValue()));
            root.getChildren().addAll(rlabel, rslider, glabel, gslider, blabel,
                    bslider, alabel, aslider, rect);
            Scene scene = new Scene(root, 460, 400);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
