package rozdzial14;

import javafx.animation.*;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing14_30 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            StackPane root = new StackPane();
            Text text = new Text("Shadow");
            text.setStrokeWidth(2);
            text.setStroke(Color.BLACK);
            text.setFill(Color.DEEPSKYBLUE);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //-
            StrokeTransition st = new StrokeTransition(Duration.millis(2000),
                    Color.RED, Color.BLUE);
            st.setCycleCount(2);
            st.setAutoReverse(true);
            //-
            FillTransition ft = new FillTransition(Duration.millis(2000),
                    Color.DEEPSKYBLUE, Color.RED);
            ft.setCycleCount(2);
            ft.setAutoReverse(true);
            //-
            FadeTransition fat = new FadeTransition(Duration.millis(2000));
            fat.setFromValue(0.2);
            fat.setToValue(0.8);
            fat.setCycleCount(2);
            fat.setAutoReverse(true);
            //-
            ScaleTransition sct = new ScaleTransition(Duration.millis(2000));
            sct.setFromX(1);
            sct.setToX(0.5);
            sct.setFromY(1);
            sct.setToY(-0.5);
            sct.setCycleCount(2);
            sct.setAutoReverse(true);
            //-
            RotateTransition rt = new RotateTransition(Duration.millis(2000));
            rt.setByAngle(15.0);
            rt.setCycleCount(2);
            rt.setAutoReverse(true);
            //-
            ParallelTransition seq = new ParallelTransition(text, st, ft, fat,
                    sct, rt);
            seq.play();
            //-
            root.getChildren().addAll(text);
            Scene scene = new Scene(root, 550, 240);
            stage.setScene(scene);
            stage.setTitle("ScaleTransition");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
