package rozdzial05;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class Listing05_12 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Rectangle rect = new Rectangle(100, 60);
            rect.setFill(Color.AQUAMARINE);
            Button but = new Button("Odpal zdarzenie");
            but.setOnAction(e -> Platform.runLater(() -> {
                IPrint.printShort(e);
                stage.fireEvent(new WindowEvent(stage,
                        WindowEvent.WINDOW_CLOSE_REQUEST));
            }));
            Circle circle = new Circle(250, 80, 30);
            circle.setFill(Color.BLUE);
            HBox root = new HBox();
            root.setSpacing(20);
            root.getChildren().addAll(rect, but, circle);
            Scene scene = new Scene(root, 410, 200);
            EventHandler<WindowEvent> windowHandler = e -> {
                System.out.print("Handler: ");
                IPrint.printShort(e);
            };
            stage.setOnShowing(windowHandler);
            stage.setOnShown(windowHandler);
            stage.setOnHiding(windowHandler);
            stage.setOnHidden(windowHandler);
            stage.setOnCloseRequest(windowHandler);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.setScene(scene);
            stage.setTitle("Zdarzenia okna");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
