package rozdzial30;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

public class Listing30_10 extends Application {
    private final int[] white = {21, 23,
            24, 26, 28, 29, 31, 33, 35,
            36, 38, 40, 41, 43, 45, 47,
            48, 50, 52, 53, 55, 57, 59,
            60, 62, 64, 65, 67, 69, 71,
            72, 74, 76, 77, 79, 81, 83,
            84, 86, 88, 89, 91, 93, 95,
            96, 98, 100, 101, 103, 105, 107,
            108
    };
    private MidiChannel channel;
    private Synthesizer synthesizer;


    public static void main(String[] args) {

        Application.launch(args);
    }

    @Override
    public void init() {

        try {
            synthesizer = MidiSystem.getSynthesizer();
            channel = synthesizer.getChannels()[0];
            synthesizer.open();
        } catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            int velocity = 64;
            int white_button_width = 20;
            int keys = 52;
            int white_button_height = 120;
            for (int i = 0; i < keys; i++) {
                Button w = new Button();
                w.getStyleClass().add("wbutton");
                w.setLayoutX(i * white_button_width);
                w.setLayoutY(0);
                w.setPrefWidth(white_button_width);
                w.setPrefHeight(white_button_height);
                final int note = white[i];
                w.setOnAction(e -> channel.noteOn(note, velocity));
                root.getChildren().add(w);
            }
            for (int i = 0; i < keys - 1; i++) {
                int j = i % 7;
                if (j == 1 || j == 4) {
                    continue;
                }
                Button b = new Button();
                b.getStyleClass().add("bbutton");
                int black_button_width = 16;
                b.setLayoutX(i * white_button_width +
                        black_button_width * 3.0 / 4.0);
                b.setLayoutY(0);
                b.setPrefWidth(black_button_width);
                int black_button_height = 80;
                b.setPrefHeight(black_button_height);
                final int note = white[i] + 1;
                b.setOnAction(e -> channel.noteOn(note, velocity));
                root.getChildren().add(b);
            }
            Scene scene = new Scene(root, keys * white_button_width,
                    white_button_height);
            scene.getStylesheets().add("resources/piano.css");
            stage.setScene(scene);
            stage.setTitle("Piano - Fortepian - Keyboard (JavaFX)");
            stage.setOnCloseRequest(e -> Platform.exit());
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        synthesizer.close();
    }
}
