package rozdzial30;

import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.scene.Scene;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class AriaPreloader2 extends Preloader {
    private Stage stage;
    private ProgressIndicator indi;

    @Override
    public void init() {
        //TO DO IF NEEDED
    }

    @Override
    public void start(Stage stage) {
        this.stage = stage;
        try {
            indi = new ProgressIndicator();
            indi.setProgress(0);
            indi.setMinSize(100,100);
            indi.setPrefWidth(100);
            indi.setPrefHeight(100);
            StackPane root = new StackPane();
            root.getChildren().add(indi);
            Scene scene = new Scene(root, 400, 224);
            stage.setScene(scene);
            stage.setTitle("AriaPreloader2");
            stage.setOnCloseRequest(e -> Platform.exit());
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleProgressNotification(ProgressNotification progressNotification) {
        super.handleProgressNotification(progressNotification);
    }

    @Override
    public void handleStateChangeNotification(StateChangeNotification stateChangeNotification) {
        if (stateChangeNotification.getType() == StateChangeNotification.Type.BEFORE_START) {
            stage.hide();
        }
    }

    @Override
    public void handleApplicationNotification(PreloaderNotification preloaderNotification) {
        if (preloaderNotification instanceof ProgressNotification) {
            double v = ((ProgressNotification) preloaderNotification).getProgress();
            indi.setProgress(v);
        }

    }

    @Override
    public boolean handleErrorNotification(ErrorNotification errorNotification) {
        return super.handleErrorNotification(errorNotification);
    }
}
