package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

import java.io.File;
import java.io.FileInputStream;

public class Listing13_12 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Image image = new Image(
                    new FileInputStream(new File("src/rozdzial13/pies.jpg")));
            ImageView imageView = new ImageView(image);
            imageView.setFitWidth(300);
            imageView.setFitHeight(285);
            imageView.setPreserveRatio(true);
            imageView.setLayoutX(230);
            imageView.setLayoutY(10);
            Pane root = new Pane();
            //efekt
            ColorAdjust ds = new ColorAdjust();
            imageView.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(-1.0, 1.0, 0);
            oxslider.setLayoutX(80);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(0.1);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.brightnessProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("brightness: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //slider 2
            Slider oyslider = new Slider(-1.0, 1.0, 0);
            oyslider.setLayoutX(80);
            oyslider.setLayoutY(60);
            oyslider.setMajorTickUnit(0.1);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.contrastProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("contrast: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(60);
            //slider 3
            Slider sslider = new Slider(-1.0, 1.0, 0);
            sslider.setLayoutX(80);
            sslider.setLayoutY(100);
            sslider.setMajorTickUnit(0.1);
            sslider.setShowTickLabels(true);
            sslider.setShowTickMarks(true);
            ds.hueProperty().bind(sslider.valueProperty());
            Label slabel = new Label("hue: ");
            slabel.setLabelFor(sslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //slider 4
            Slider rslider = new Slider(-1.0, 1.0, 0);
            rslider.setLayoutX(80);
            rslider.setLayoutY(140);
            rslider.setMajorTickUnit(0.1);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            ds.saturationProperty().bind(rslider.valueProperty());
            Label rlabel = new Label("saturation: ");
            rlabel.setLabelFor(rslider);
            rlabel.setLayoutX(20);
            rlabel.setLayoutY(140);
            //colorPicker
            root.getChildren().addAll(oxslabel, oxslider, oyslabel, oyslider,
                    sslider, slabel, rlabel, rslider, imageView);
            Scene scene = new Scene(root, 560, 300);
            stage.setScene(scene);
            stage.setTitle("ColorAdjust");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
