package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_05 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Text text = new Text("Shadow");
            text.setX(220);
            text.setY(100);
            text.setFill(Color.AQUAMARINE);
            //text.setStroke(Color.BLACK);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            GaussianBlur ds = new GaussianBlur();
            text.setEffect(ds);
            //slider 3
            Slider cslider = new Slider(0, 63, 10);
            cslider.setLayoutX(80);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(10);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.radiusProperty().bind(cslider.valueProperty());
            Label slabel = new Label("radius: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //
            root.getChildren().addAll(cslider, slabel, text);
            Scene scene = new Scene(root, 560, 280);
            scene.setFill(Color.WHITE);
            stage.setScene(scene);
            stage.setTitle("GaussianBlur");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
