package com.corejsf;

import javax.faces.event.ActionEvent;
 
public class TabbedPane {
   private int index;
   private static final int JEFFERSON_INDEX = 0;
   private static final int ROOSEVELT_INDEX = 1; 
   private static final int LINCOLN_INDEX = 2;
   private static final int WASHINGTON_INDEX = 3;

   private String[] tabs = { "jeffersonTabText", "rooseveltTabText",
         "lincolnTabText",  "washingtonTabText", };

   private String[] tabTooltips = { "jeffersonTooltip", "rooseveltTooltip",
         "lincolnTooltip",  "washingtonTooltip" };

   public TabbedPane() {
      index = JEFFERSON_INDEX;
   }

   // metody nasuchujce akcji odpowiedzialne za ustawianie biecej zakadki

   public void jeffersonAction(ActionEvent e) { index = JEFFERSON_INDEX;  }
   public void rooseveltAction(ActionEvent e) { index = ROOSEVELT_INDEX;  }
   public void lincolnAction(ActionEvent e) { index = LINCOLN_INDEX;    }
   public void washingtonAction(ActionEvent e) { index = WASHINGTON_INDEX; }

   // style CSS

   public String getJeffersonStyle() { return getCSS(JEFFERSON_INDEX);  }
   public String getRooseveltStyle() { return getCSS(ROOSEVELT_INDEX);  }
   public String getLincolnStyle() { return getCSS(LINCOLN_INDEX);    }
   public String getWashingtonStyle() { return getCSS(WASHINGTON_INDEX); }

   private String getCSS(int forIndex) {
      return forIndex == index ? "tabbedPaneTextSelected" : "tabbedPaneText"; 
   }

   // metody okrelajce biec zakadk

   public boolean isJeffersonCurrent() { return index == JEFFERSON_INDEX;  }
   public boolean isRooseveltCurrent() { return index == ROOSEVELT_INDEX;  }
   public boolean isLincolnCurrent() { return index == LINCOLN_INDEX;    }
   public boolean isWashingtonCurrent() { return index == WASHINGTON_INDEX; }

   // metody zwracajce podpowiedzi dla tytuw zakadek

   public String getJeffersonTooltip() { 
      return com.corejsf.util.Messages.getString(
            "com.corejsf.messages", tabTooltips[JEFFERSON_INDEX], null); 
   }
   public String getRooseveltTooltip() { 
      return com.corejsf.util.Messages.getString(
            "com.corejsf.messages", tabTooltips[ROOSEVELT_INDEX], null); 
   }
   public String getLincolnTooltip() { 
      return com.corejsf.util.Messages.getString(
            "com.corejsf.messages", tabTooltips[LINCOLN_INDEX], null); 
   }
   public String getWashingtonTooltip() { 
      return com.corejsf.util.Messages.getString(
            "com.corejsf.messages", tabTooltips[WASHINGTON_INDEX], null); 
   }
}
