/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.component;

import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UINamingContainer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.util.Messages;
import org.apache.shale.view.ViewController;

public class Subview
extends UINamingContainer {
    private static final Log log = LogFactory.getLog((Class)Subview.class);
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", Subview.class.getClassLoader());

    public void encodeBegin(FacesContext context) {
        ViewController vc = this.getViewController(context, false);
        if (vc != null) {
            vc.prerender();
        }
        super.processDecodes(context);
    }

    public void processDecodes(FacesContext context) {
        ViewController vc = this.getViewController(context, true);
        if (vc != null) {
            vc.preprocess();
        }
        super.processDecodes(context);
    }

    private ViewController getViewController(FacesContext context, boolean postback) {
        String name = this.getId();
        ExternalContext econtext = context.getExternalContext();
        ViewController vc = null;
        vc = (ViewController)econtext.getRequestMap().get(name);
        if (vc == null) {
            vc = (ViewController)econtext.getSessionMap().get(name);
        }
        if (vc == null) {
            vc = (ViewController)econtext.getApplicationMap().get(name);
        }
        if (vc != null) {
            return vc;
        }
        String expr = "#{" + name + "}";
        try {
            vc = (ViewController)context.getApplication().createValueBinding(expr).getValue(context);
            if (vc == null) {
                log.warn((Object)messages.getMessage("subview.noBean", new Object[]{this.getId()}));
                return null;
            }
        }
        catch (ClassCastException e) {
            log.error((Object)messages.getMessage("subview.noType", new Object[]{this.getId()}));
            return null;
        }
        vc.setPostBack(postback);
        vc.init();
        Map map = econtext.getRequestMap();
        ArrayList<ViewController> list = (ArrayList<ViewController>)map.get("org.apache.shale.view.VIEWS_INITIALIZED");
        if (list == null) {
            list = new ArrayList<ViewController>();
            map.put("org.apache.shale.view.VIEWS_INITIALIZED", list);
        }
        list.add(vc);
        return vc;
    }
}

