/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.microcontainer;

import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.local.LocalTxDataSource;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.CachedConnectionManagerReference;
import org.jboss.seam.util.NamingHelper;

public class DataSourceFactory {
    private static final Logger log = Logger.getLogger(DataSourceFactory.class);
    private LocalTxDataSource ds;
    private int maxSize = 20;
    private int minSize = 0;
    private int blockingTimeout = 30000;
    private int idleTimeout = 900000;
    private String connectionUrl;
    private String driverClass;
    private String userName;
    private String password;
    private int preparedStatementCacheSize;
    private String checkValidConnectionSql;
    private String jndiName;
    private TransactionManager transactionManager;

    public Object getDataSource() throws Exception {
        log.info((Object)("starting Datasource at JNDI name: " + this.jndiName));
        CachedConnectionManager ccm = new CachedConnectionManager();
        CachedConnectionManagerReference ccmr = new CachedConnectionManagerReference();
        ccmr.setCachedConnectionManager(ccm);
        ccmr.setTransactionManager(this.transactionManager);
        this.ds = new LocalTxDataSource();
        this.ds.setConnectionURL(this.connectionUrl);
        this.ds.setDriverClass(this.driverClass);
        this.ds.setUserName(this.userName);
        this.ds.setPassword(this.password);
        this.ds.setPreparedStatementCacheSize(this.preparedStatementCacheSize);
        this.ds.setCheckValidConnectionSQL(this.checkValidConnectionSql);
        this.ds.setMaxSize(this.maxSize);
        this.ds.setMinSize(this.minSize);
        this.ds.setBlockingTimeout(this.blockingTimeout);
        this.ds.setIdleTimeout((long)this.idleTimeout);
        this.ds.setTransactionManager(this.transactionManager);
        this.ds.setJndiName(this.jndiName);
        this.ds.setCachedConnectionManager(ccmr);
        this.ds.setInitialContextProperties(NamingHelper.getInitialContextProperties());
        this.ds.start();
        return this.ds;
    }

    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public void setCheckValidConnectionSql(String checkValidConnectionSql) {
        this.checkValidConnectionSql = checkValidConnectionSql;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

