/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ManagedHibernateSession;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.ManagedPersistenceContext;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.util.NamingHelper;
import org.jboss.seam.util.Transactions;

public class SeamTransactionManagedPersistencePhaseListener
extends SeamPhaseListener {
    private static final Logger log = Logger.getLogger(SeamTransactionManagedPersistencePhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.begin();
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        boolean flush;
        boolean commit = event.getPhaseId() == PhaseId.RENDER_RESPONSE || event.getFacesContext().getResponseComplete();
        boolean bl = flush = event.getPhaseId() == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse();
        if (commit) {
            this.commit();
        } else if (flush) {
            this.flush();
        }
        super.afterPhase(event);
    }

    private void begin() {
        try {
            if (!Transactions.isTransactionActive()) {
                log.debug((Object)"Starting transaction prior to RESTORE_VIEW phase");
                Transactions.getUserTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    private void commit() {
        try {
            if (Transactions.isTransactionActive()) {
                log.debug((Object)"Committing transaction after RENDER_RESPONSE phase or responseComplete()");
                Transactions.getUserTransaction().commit();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }

    private void flush() {
        try {
            log.debug((Object)"Flushing persistence contexts after INVOKE_APPLICATION phase");
            if (Transactions.isTransactionActive()) {
                Init init = Init.instance();
                for (String unitName : init.getManagedPersistenceContexts()) {
                    this.flushEntityManager(unitName);
                }
                for (String sfName : init.getManagedSessions()) {
                    this.flushSession(sfName);
                }
                if (init.isJbpmInstalled()) {
                    this.flushJbpm();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not flush to database", e);
        }
    }

    private void flushEntityManager(String unitName) throws NamingException {
        EntityManager em;
        log.trace((Object)("flushing EntityManager [" + unitName + "]"));
        ManagedPersistenceContext managedContext = (ManagedPersistenceContext)Contexts.getConversationContext().get(unitName);
        if (managedContext != null) {
            managedContext.getEntityManager().flush();
        }
        if ((em = (EntityManager)NamingHelper.getInitialContext().lookup("java:/EntityManagers/" + unitName)) != null) {
            em.flush();
        }
    }

    private void flushSession(String sfName) {
        log.trace((Object)("flushing Hibernate session [" + sfName + "]"));
        ManagedHibernateSession managedSession = (ManagedHibernateSession)Contexts.getConversationContext().get(sfName);
        if (managedSession != null) {
            managedSession.getSession().flush();
        }
    }

    private void flushJbpm() {
        log.trace((Object)"flushing jBPM session");
        ManagedJbpmContext managed = (ManagedJbpmContext)Contexts.getEventContext().get(Seam.getComponentName(ManagedJbpmContext.class));
        if (managed != null) {
            Contexts.getBusinessProcessContext().flush();
            managed.getJbpmContext().getSession().flush();
        }
    }
}

