/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.Process;

@Scope(value=ScopeType.APPLICATION)
@Name(value="processInstance")
@Intercept(value=InterceptionType.NEVER)
@Startup
public class ProcessInstance {
    @Unwrap
    public org.jbpm.graph.exe.ProcessInstance getProcessInstance() {
        if (!Contexts.isConversationContextActive()) {
            return null;
        }
        Long processId = Process.instance().getProcessId();
        if (processId != null) {
            return ManagedJbpmContext.instance().getGraphSession().loadProcessInstance(processId.longValue());
        }
        return null;
    }

    public static org.jbpm.graph.exe.ProcessInstance instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (org.jbpm.graph.exe.ProcessInstance)Component.getInstance(ProcessInstance.class, ScopeType.APPLICATION, true);
    }
}

