/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScopeType {
    STATELESS,
    EVENT,
    PAGE,
    CONVERSATION,
    SESSION,
    APPLICATION,
    BUSINESS_PROCESS,
    UNSPECIFIED;


    public Context getContext() {
        switch (this) {
            case STATELESS: {
                return Contexts.getStatelessContext();
            }
            case EVENT: {
                if (!Contexts.isEventContextActive()) {
                    throw new IllegalStateException("No event context active");
                }
                return Contexts.getEventContext();
            }
            case PAGE: {
                if (!Contexts.isPageContextActive()) {
                    throw new IllegalStateException("No page context active");
                }
                return Contexts.getPageContext();
            }
            case CONVERSATION: {
                if (!Contexts.isConversationContextActive()) {
                    throw new IllegalStateException("No conversation context active");
                }
                return Contexts.getConversationContext();
            }
            case SESSION: {
                if (!Contexts.isSessionContextActive()) {
                    throw new IllegalStateException("No session context active");
                }
                return Contexts.getSessionContext();
            }
            case APPLICATION: {
                if (!Contexts.isApplicationContextActive()) {
                    throw new IllegalStateException("No application context active");
                }
                return Contexts.getApplicationContext();
            }
            case BUSINESS_PROCESS: {
                if (!Contexts.isBusinessProcessContextActive()) {
                    throw new IllegalStateException("No process context active");
                }
                return Contexts.getBusinessProcessContext();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getPrefix() {
        return "org.jboss.seam." + this.toString();
    }
}

