/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tiles.ComponentDefinitions;
import org.apache.tiles.DefinitionsFactory;
import org.apache.tiles.ReloadableDefinitionsFactory;
import org.apache.tiles.TilesUtil;

public class TilesFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static final boolean debug = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            DefinitionsFactory factory = TilesUtil.getDefinitionsFactory(request, this.filterConfig.getServletContext());
            if (factory instanceof ReloadableDefinitionsFactory && ((ReloadableDefinitionsFactory)((Object)factory)).refreshRequired()) {
                ComponentDefinitions definitions;
                this.log("Updating Tiles definitions.");
                ComponentDefinitions newDefs = null;
                DefinitionsFactory definitionsFactory = factory;
                synchronized (definitionsFactory) {
                    newDefs = factory.readDefinitions();
                }
                ComponentDefinitions componentDefinitions = definitions = (ComponentDefinitions)this.filterConfig.getServletContext().getAttribute("org.apache.tiles.ComponentDefinitions");
                synchronized (componentDefinitions) {
                    definitions.reset();
                    definitions.addDefinitions(newDefs.getBaseDefinitions());
                }
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            throw new ServletException("Error processing request.", (Throwable)e);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.log("TilesFilter:Initializing filter");
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }
}

