/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.ComponentDefinition;
import org.apache.tiles.ComponentDefinitions;
import org.apache.tiles.ComponentDefinitionsFactory;
import org.apache.tiles.DefinitionsFactory;
import org.apache.tiles.DefinitionsFactoryConfig;
import org.apache.tiles.DefinitionsFactoryException;
import org.apache.tiles.FactoryNotFoundException;
import org.apache.tiles.definition.ComponentDefinitionsFactoryWrapper;
import org.apache.tiles.util.RequestUtils;

public class TilesUtilImpl
implements Serializable {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$tiles$TilesUtil == null ? (class$org$apache$tiles$TilesUtil = TilesUtilImpl.class$("org.apache.tiles.TilesUtil")) : class$org$apache$tiles$TilesUtil));
    public static final String DEFINITIONS_FACTORY = "org.apache.tiles.DEFINITIONS_FACTORY";
    public static final String DEFINITIONS_OBJECT = "org.apache.tiles.ComponentDefinitions";
    private static Method include = null;
    static /* synthetic */ Class class$org$apache$tiles$TilesUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$servlet$jsp$PageContext;

    public void doForward(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).include((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, PageContext pageContext, boolean flush) throws IOException, ServletException {
        try {
            if (include != null) {
                include.invoke((Object)pageContext, uri, flush);
                return;
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Could not find JSP 2.0 include method.  Using old one.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Unable to execute JSP 2.0 include method.  Trying old one.", (Throwable)e);
        }
        pageContext.include(uri);
    }

    public DefinitionsFactory getDefinitionsFactory(ServletRequest request, ServletContext servletContext) {
        return (DefinitionsFactory)servletContext.getAttribute(DEFINITIONS_FACTORY);
    }

    public DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, DefinitionsFactoryConfig factoryConfig) throws DefinitionsFactoryException {
        String factoryClassName = "org.apache.tiles.definition.UrlDefinitionsFactory";
        DefinitionsFactory factory = this.createDefinitionFactoryInstance(factoryClassName);
        Map params = factoryConfig.getAttributes();
        factory.init(params);
        String configFiles = factoryConfig.getDefinitionConfigFiles();
        List filenames = this.getFilenames(configFiles);
        try {
            for (int i = 0; i < filenames.size(); ++i) {
                String filename = (String)filenames.get(i);
                factory.addSource(servletContext.getResource(filename));
            }
        }
        catch (MalformedURLException e) {
            throw new DefinitionsFactoryException("Problem with filename URL: ", e);
        }
        ComponentDefinitions definitions = factory.readDefinitions();
        this.makeDefinitionsFactoryAccessible(factory, servletContext);
        this.makeDefinitionsAccessible(definitions, servletContext);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentDefinition getDefinition(String definitionName, ServletRequest request, ServletContext servletContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        try {
            DefinitionsFactory factory = this.getDefinitionsFactory(request, servletContext);
            ComponentDefinitions definitions = (ComponentDefinitions)servletContext.getAttribute(DEFINITIONS_OBJECT);
            ComponentDefinition definition = definitions.getDefinition(definitionName, request.getLocale());
            if (definition == null) {
                if (!factory.isLocaleProcessed(request.getLocale())) {
                    ComponentDefinitions componentDefinitions = definitions;
                    synchronized (componentDefinitions) {
                        factory.addDefinitions(definitions, request.getLocale());
                    }
                }
                definition = definitions.getDefinition(definitionName, request.getLocale());
            }
            return definition;
        }
        catch (NullPointerException ex) {
            throw new FactoryNotFoundException("Can't get definitions factory from context.");
        }
    }

    protected DefinitionsFactory createDefinitionFactoryInstance(String classname) throws DefinitionsFactoryException {
        try {
            Class factoryClass = RequestUtils.applicationClass(classname);
            Object factory = factoryClass.newInstance();
            if (factory instanceof ComponentDefinitionsFactory) {
                factory = new ComponentDefinitionsFactoryWrapper((ComponentDefinitionsFactory)factory);
            }
            return (DefinitionsFactory)factory;
        }
        catch (ClassCastException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + classname + " must implement 'DefinitionsFactory'.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + classname + "'.", ex);
        }
        catch (InstantiationException ex) {
            throw new DefinitionsFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new DefinitionsFactoryException(ex);
        }
    }

    protected void makeDefinitionsFactoryAccessible(DefinitionsFactory factory, ServletContext servletContext) {
        servletContext.setAttribute(DEFINITIONS_FACTORY, (Object)factory);
    }

    protected void makeDefinitionsAccessible(ComponentDefinitions definitions, ServletContext servletContext) {
        servletContext.setAttribute(DEFINITIONS_OBJECT, (Object)definitions);
    }

    protected List getFilenames(String filenameString) {
        StringTokenizer tokenizer = new StringTokenizer(filenameString, ",");
        ArrayList<String> filenames = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            filenames.add(tokenizer.nextToken().trim());
        }
        return filenames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TilesUtilImpl.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE};
            include = (class$javax$servlet$jsp$PageContext == null ? (class$javax$servlet$jsp$PageContext = TilesUtilImpl.class$("javax.servlet.jsp.PageContext")) : class$javax$servlet$jsp$PageContext).getMethod("include", args);
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)"Could not find JSP 2.0 include method.  Using old one that doesn't support configurable flushing.", (Throwable)e);
        }
    }
}

