/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.recovery.BatchRecoveryLogger;
import org.jboss.tm.recovery.BatchRecoveryLoggerServiceMBean;
import org.jboss.tm.recovery.RecoveryLogger;

public class BatchRecoveryLoggerService
extends ServiceMBeanSupport
implements BatchRecoveryLoggerServiceMBean {
    protected BatchRecoveryLogger logger = this.createLogger();
    private ObjectName xidFactory;

    protected BatchRecoveryLogger createLogger() {
        return new BatchRecoveryLogger();
    }

    public void startService() throws Exception {
        super.startService();
        XidFactoryMBean xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        this.logger.setXidFactory(xidFactoryObj);
        this.logger.start();
    }

    public void stopService() throws Exception {
        super.stopService();
        this.logger.stop();
    }

    public RecoveryLogger getInstance() {
        return this.logger;
    }

    public String[] getDirectoryList() {
        return this.logger.getDirectoryList();
    }

    public void setDirectoryList(String[] directoryList) {
        this.logger.setDirectoryList(directoryList);
    }

    public int getLogFileSize() {
        return this.logger.getLogFileSize();
    }

    public void setLogFileSize(int logFileSize) {
        this.logger.setLogFileSize(logFileSize);
    }

    public String getHeuristicStatusLogDirectory() {
        return this.logger.getHeuristicStatusLogDirectory();
    }

    public void setHeuristicStatusLogDirectory(String directory) {
        this.logger.setHeuristicStatusLogDirectory(directory);
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }
}

