/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.recovery.CorruptedLogRecordException;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.RecoveryLogReader;

class BatchRecoveryLogReader
implements RecoveryLogReader {
    private static Logger errorLog = Logger.getLogger((Class)BatchRecoveryLogReader.class);
    private File logFile;
    private XidFactoryBase xidFactory;

    BatchRecoveryLogReader(File logFile, XidFactoryBase xidFactory) {
        this.logFile = logFile;
        this.xidFactory = xidFactory;
    }

    private Object readHeaderObject(DataInputStream dis) throws IOException, ClassNotFoundException {
        int num = dis.readInt();
        byte[] bytes = new byte[num];
        dis.read(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public String getLogFileName() {
        return this.logFile.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBranchQualifier() {
        String string;
        FileInputStream fis = new FileInputStream(this.logFile);
        DataInputStream dis = new DataInputStream(fis);
        try {
            string = (String)this.readHeaderObject(dis);
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        fis.close();
        return string;
    }

    public void recover(List committedSingleTmTransactions, List committedMultiTmTransactions, List inDoubtTransactions, List inDoubtJcaTransactions) {
        DataInputStream dis;
        FileInputStream fis;
        HashMap<Long, LogRecord.Data> activeMultiTmTransactions = new HashMap<Long, LogRecord.Data>();
        CorruptedLogRecordException corruptedLogRecordException = null;
        try {
            fis = new FileInputStream(this.logFile);
            dis = new DataInputStream(fis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            LogRecord.Data data;
            this.readHeaderObject(dis);
            if (fis.available() < LogRecord.FULL_HEADER_LEN) {
                return;
            }
            FileChannel channel = fis.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(LogRecord.FULL_HEADER_LEN);
            channel.read(buf);
            int len = LogRecord.getNextRecordLength(buf, 0);
            while (len > 0) {
                long corruptedRecordPos;
                long nextPos;
                buf = ByteBuffer.allocate(len + LogRecord.FULL_HEADER_LEN);
                if (channel.read(buf) < len) {
                    errorLog.info((Object)("Unexpected end of file in transaction log file " + this.logFile.getName()));
                    break;
                }
                buf.flip();
                data = new LogRecord.Data();
                try {
                    LogRecord.getData(buf, len, data);
                }
                catch (CorruptedLogRecordException e) {
                    if (corruptedLogRecordException == null) {
                        corruptedLogRecordException = e;
                    }
                    if ((nextPos = this.scanForward((corruptedRecordPos = channel.position() - (long)buf.limit() - (long)LogRecord.FULL_HEADER_LEN) + 1L)) == 0L) {
                        errorLog.info((Object)("LOG CORRUPTION AT THE END OF LOG FILE " + this.logFile.getName()));
                        break;
                    }
                    errorLog.info((Object)("LOG CORRUPTION IN THE MIDDLE OF LOG FILE " + this.logFile.getName() + ". Skipping " + (nextPos - corruptedRecordPos) + " bytes" + ". Disabling presumed rollback."));
                    channel.position(nextPos);
                    buf = ByteBuffer.allocate(LogRecord.FULL_HEADER_LEN);
                    channel.read(buf);
                    len = LogRecord.getNextRecordLength(buf, 0);
                    corruptedLogRecordException.disablePresumedRollback = true;
                    continue;
                }
                switch (data.recordType) {
                    case 67: {
                        data.globalTransactionId = this.xidFactory.localIdToGlobalId(data.localTransactionId);
                        committedSingleTmTransactions.add(data);
                        break;
                    }
                    case 77: {
                        data.globalTransactionId = this.xidFactory.localIdToGlobalId(data.localTransactionId);
                    }
                    case 80: 
                    case 82: {
                        activeMultiTmTransactions.put(new Long(data.localTransactionId), data);
                        break;
                    }
                    case 69: {
                        activeMultiTmTransactions.remove(new Long(data.localTransactionId));
                        break;
                    }
                    default: {
                        errorLog.warn((Object)"INVALID TYPE IN LOG RECORD.");
                    }
                }
                try {
                    len = LogRecord.getNextRecordLength(buf, len);
                }
                catch (CorruptedLogRecordException e) {
                    if (corruptedLogRecordException == null) {
                        corruptedLogRecordException = e;
                    }
                    if ((nextPos = this.scanForward((corruptedRecordPos = channel.position() - (long)buf.limit() - (long)LogRecord.FULL_HEADER_LEN) + 1L)) == 0L) {
                        errorLog.info((Object)("LOG CORRUPTION AT THE END OF LOG FILE " + this.logFile.getName()));
                        len = 0;
                        continue;
                    }
                    errorLog.info((Object)("LOG CORRUPTION IN THE MIDDLE OF LOG FILE " + this.logFile.getName() + ". Skipping " + (nextPos - corruptedRecordPos) + " bytes" + ". Disabling presumed rollback."));
                    channel.position(nextPos);
                    buf = ByteBuffer.allocate(LogRecord.FULL_HEADER_LEN);
                    channel.read(buf);
                    len = LogRecord.getNextRecordLength(buf, 0);
                    corruptedLogRecordException.disablePresumedRollback = true;
                }
            }
            Iterator iter = activeMultiTmTransactions.values().iterator();
            block23: while (iter.hasNext()) {
                data = (LogRecord.Data)iter.next();
                switch (data.recordType) {
                    case 77: {
                        committedMultiTmTransactions.add(data);
                        continue block23;
                    }
                    case 80: {
                        inDoubtTransactions.add(data);
                        continue block23;
                    }
                    case 82: {
                        inDoubtJcaTransactions.add(data);
                        continue block23;
                    }
                }
                errorLog.warn((Object)"INCONSISTENT STATE.");
            }
            if (corruptedLogRecordException != null) {
                throw corruptedLogRecordException;
            }
        }
        catch (IOException e) {
            errorLog.warn((Object)"Unexpected exception in recover:", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            errorLog.warn((Object)"Unexpected exception in recover:", (Throwable)e);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishRecovery() {
        this.logFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long scanForward(long pos) {
        errorLog.trace((Object)"entering scanForward");
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.logFile, "r");
            while (pos + (long)LogRecord.FULL_HEADER_LEN < this.logFile.length()) {
                if (BatchRecoveryLogReader.match(file, pos, LogRecord.HEADER)) {
                    errorLog.trace((Object)("scanForward: match at pos=" + pos));
                    file.seek(pos + (long)LogRecord.HEADER_LEN);
                    short recLen = file.readShort();
                    errorLog.trace((Object)("scanForward: recLen=" + recLen));
                    if (pos + (long)LogRecord.FULL_HEADER_LEN + (long)recLen < this.logFile.length()) {
                        byte[] buf = new byte[recLen];
                        file.seek(pos + (long)LogRecord.FULL_HEADER_LEN);
                        file.read(buf, 0, recLen);
                        if (LogRecord.hasValidChecksum(buf)) {
                            errorLog.trace((Object)("scanForward: returning " + pos));
                            long l = pos;
                            return l;
                        }
                        errorLog.trace((Object)("scanForward: bad checksum in record at pos=" + pos));
                        pos += (long)LogRecord.HEADER_LEN;
                        continue;
                    }
                    pos = LogRecord.HEADER_LEN;
                    continue;
                }
                ++pos;
            }
            errorLog.trace((Object)"scanForward: returning 0");
            long recLen = 0L;
            return recLen;
        }
        catch (FileNotFoundException e) {
            errorLog.warn((Object)"Unexpected exception in scanForward:", (Throwable)e);
            long l = 0L;
            return l;
        }
        catch (IOException e) {
            errorLog.warn((Object)"Unexpected exception in scanForward:", (Throwable)e);
            long l = 0L;
            return l;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    errorLog.warn((Object)"Unexpected exception in scanForward:", (Throwable)e);
                }
            }
        }
    }

    private static boolean match(RandomAccessFile file, long pos, byte[] pattern) throws IOException {
        for (int i = 0; i < pattern.length; ++i) {
            file.seek(pos + (long)i);
            if (file.readByte() == pattern[i]) continue;
            return false;
        }
        return true;
    }
}

