/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;
import org.jboss.tm.recovery.BatchWriter;
import org.jboss.tm.recovery.TxCompletionHandler;

class BatchLog
implements TxCompletionHandler {
    private static Logger errorLog = Logger.getLogger((Class)BatchLog.class);
    private static final int CLEAN_LENGTH = 16384;
    private static byte[] nulls = new byte[16384];
    private File logFile;
    private RandomAccessFile os;
    private FileChannel channel;
    private volatile int numLoggedTransactions;
    private volatile int numEndRecords;
    private int numLocalTransactionsCompleted;
    private boolean markedForRestart;
    private Object header;
    private long topFp;
    private BatchWriter writer;
    private ByteBuffer cleanBuffer = ByteBuffer.wrap(nulls);

    BatchLog(BatchWriter writer, Object header, File dir, int fileSize) throws IOException {
        this.writer = writer;
        this.header = header;
        this.logFile = File.createTempFile("TX_RECOVERY_LOG", ".log", dir);
        this.os = new RandomAccessFile(this.logFile, "rw");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(header);
        byte[] bytes = baos.toByteArray();
        this.os.setLength(fileSize);
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
        this.channel = this.os.getChannel();
        this.channel.force(true);
        this.topFp = this.channel.position();
        this.cleanUpLogFile();
    }

    BatchWriter getBatchWriter() {
        return this.writer;
    }

    int getPosition() throws IOException {
        return (int)this.channel.position();
    }

    String getFilename() {
        return this.logFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ByteBuffer record, boolean isEndRecord) throws IOException {
        this.channel.write(record);
        if (isEndRecord) {
            ++this.numEndRecords;
            BatchLog batchLog = this;
            synchronized (batchLog) {
                if (this.markedForRestart && this.numLoggedTransactions == this.numLocalTransactionsCompleted + this.numEndRecords) {
                    this.writer.restartBatchLog(this);
                }
            }
        } else {
            this.channel.force(false);
            ++this.numLoggedTransactions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ByteBuffer[] records, int offset, int length, int numTransactionRecords) throws IOException {
        this.channel.write(records, offset, length);
        if (numTransactionRecords > 0) {
            this.channel.force(false);
            this.numLoggedTransactions += numTransactionRecords;
        }
        if (numTransactionRecords < length) {
            this.numEndRecords += length - numTransactionRecords;
            BatchLog batchLog = this;
            synchronized (batchLog) {
                if (this.markedForRestart && this.numLoggedTransactions == this.numLocalTransactionsCompleted + this.numEndRecords) {
                    this.writer.restartBatchLog(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTxCompletion(long localTransactionId) {
        BatchLog batchLog = this;
        synchronized (batchLog) {
            ++this.numLocalTransactionsCompleted;
            if (this.markedForRestart && this.numLoggedTransactions == this.numLocalTransactionsCompleted + this.numEndRecords) {
                this.writer.restartBatchLog(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markForRestart() {
        BatchLog batchLog = this;
        synchronized (batchLog) {
            this.markedForRestart = true;
            if (this.numLoggedTransactions == this.numLocalTransactionsCompleted + this.numEndRecords) {
                this.writer.restartBatchLog(this);
            }
        }
    }

    void restart() throws IOException {
        this.channel.position(this.topFp);
        this.cleanUpLogFile();
        this.writer.getNextLogs().add(this);
    }

    void cleanUpLogFile() throws IOException {
        this.numLoggedTransactions = 0;
        this.numLocalTransactionsCompleted = 0;
        this.numEndRecords = 0;
        this.markedForRestart = false;
        this.cleanBuffer.limit(this.cleanBuffer.capacity());
        while (this.channel.position() <= this.channel.size() - (long)this.cleanBuffer.limit()) {
            this.cleanBuffer.rewind();
            this.channel.write(this.cleanBuffer);
        }
        this.cleanBuffer.limit((int)(this.channel.size() - this.channel.position()));
        this.cleanBuffer.rewind();
        this.channel.write(this.cleanBuffer);
        this.channel.force(false);
        this.channel.position(this.topFp);
    }

    void close() {
        errorLog.info((Object)("Closing transaction log " + this.getFilename() + ", numLoggedTransactions=" + this.numLoggedTransactions + ", numLocalTransactionsCompleted=" + this.numLocalTransactionsCompleted + ", numEndRecords=" + this.numEndRecords));
        try {
            if (this.numLoggedTransactions == this.numLocalTransactionsCompleted + this.numEndRecords) {
                this.channel.position(this.topFp);
                this.channel.truncate(this.topFp);
            }
            this.os.close();
        }
        catch (IOException e) {
            errorLog.error((Object)("Error closing transaction log " + this.getFilename()), (Throwable)e);
        }
    }
}

